%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% fit to Scheidegger BTC using FEM-1D v45.3
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc;		% clc clears the command window
clear all;	% remove all variables, globals, functions and MEX links
close all;	% close all the open figure windows
fclose('all');  % close all files

% input

%%%%%%%%%%% read finp.txt %%%%%%%%%%%%
fid = fopen('finp.txt','r');

line = fgets(fid);	% read line (Ne, Nn, Nb, Nm, Np)
v = sscanf(line, '%i');
Nn = v(2);

line = fgets(fid);	% read line (Nd, Ng, Ns)
line = fgets(fid);	% read line (Sx, Kappa, tc)
line = fgets(fid);	% read line (tmax, dt, dto)
v = sscanf(line, '%e');
tmax = v(1);
dto  = v(3);
fclose(fid);

tmin = 0;			% FEM tmin
points = (tmax-tmin)/dto+1;	% No. of FEM time steps

%%%%%%%%%%% read nodes.txt %%%%%%%%%%%%
fid = fopen('nodes.txt','r');
x = zeros(1,Nn);
for n=1:Nn
  line = fgets(fid);	% read line ( i, x, c(x,y,0 1:Ns) )
  v = sscanf(line, '%e');
  x(n) = v(2);
end	%	n
fclose(fid);
L = max(x) - min(x);

% Initial parameter guess
beta = 1.5;
t1   = 2.e-2;
t2   = 2.e10;

% Input of v and D must be in units of 1/TIME: i.e., divide the dimensional
% v and D by L (column length) and L^2, respectively.
v = 9.e-3/L;	% v_psi [T^-1]
D = 1.e-5/L^2;	% D_psi [T^-2]

% NOTE: Do not forget to reconvert to real dimensional units of v and D; 
%   multiply  v  and  D  by L (column length) and L^2, respectively. 

% the desired precision for fitting Prony parameters with sop2
errbnd = 1.e-6;

% Name of input data file; The .m suffix must be omitted
data_1

% Interpolation of data file
xa = a(:,1); 
ya = a(:,2); 


minxa = tmin;
maxxa = tmax;  
t0 = transpose(linspace(minxa,maxxa,points)); 
data(:,1) = t0; 
data(:,2) = interp1(xa,ya,t0);  % NOTE: resuts in NaN if extrapolated !!!
data  = transpose(data);	% transpose data to the dimensions of the FEM t and Cfo

% Name of output data file
output = 'Scheidegger.txt' ;

TolFun = 0.1;	% Termination tolerance on the function value [ positive scalar ]
TolX = 1.e99;	% Termination tolerance on X [ positive scalar ]
MaxFunEvals = 1000;
MaxIter = 100;

fid = fopen(output,'w');
fprintf(fid,'--------- optim-v54.3 of 23/08/18 --------- \n');	% version ID

% Generate the result for the first guess
fprintf(fid,'L \t = %14.7e \n', L);
fprintf(fid,'v \t = %14.7e \n', v);
fprintf(fid,'D \t = %14.7e \n', D);
fprintf(fid,'beta \t = %14.7e \n', beta);
fprintf(fid,'t1 \t = %14.7e \n', t1);
fprintf(fid,'t2 \t = %14.7e \n', t2);
fprintf(fid,'TolFun \t = %14.7e \n', TolFun);
fprintf(fid,'TolX \t = %14.7e \n', TolX);
fprintf(fid,'MaxFunEvals \t = %7i \n', MaxFunEvals);
fprintf(fid,'MaxIter \t = %7i \n', MaxIter);
fprintf(fid,'tmin \t = %14.7e \n', tmin);
fprintf(fid,'tmax \t = %14.7e \n', tmax);
fprintf(fid,'dto \t = %14.7e \n', dto );
fprintf(fid,'errbnd \t = %14.7e \n', errbnd);
fprintf(fid,'points \t = %7i \n', points);

fid = fopen(output,'a');

% Calculation of normalized error

% initiate minimization
vDp_old = [v D beta t1 t2 ];		% optimized parameters
unchanged = {data, errbnd, output};	% non-optimized parameters

err_old = diff_norm(vDp_old, unchanged);
vDp = vDp_old;
err = err_old;

% Minimization algorithm

OPTS = optimset('Display','iter', 'MaxFunEvals',MaxFunEvals, 'MaxIter',MaxIter, 'TolFun',TolFun,'TolX',TolX); 
[vDp, FVAL , EXITFLAG] = my_fminsearch('diff_norm', vDp , OPTS ,unchanged);
err = diff_norm(vDp, unchanged);
fprintf(1,' err \t = %6.4e \n',err);

%%%%%%%%%%% run post_f_1 to get the BTC as t and Cfo arrays
[t Cfo] = post_f_1();

% Output file
gen_output(vDp_old, vDp, err_old, err, output)

fclose('all');  % close all files

